
#
#
# Generate palette
#
#


set hex_list {0 1 2 3 4 5 6 7 8 9 A B C D E F}
set color_list {}

set n_colors 20
set S 7
set PI 3.1415

#
#  vectors:  (1,1,1) - brightness
#   (1,1,-2) /sqrt(6)
#   (-1,1,0) /sqrt(2)
#

set s_2 [expr sqrt(2.0)]
set s_6 [expr sqrt(6.0)]
for {set I 12} {$I > 4} {incr I -3} {
for {set i 0} {$i<$n_colors} {incr i} {
	set H [expr (2*$PI*$i/$n_colors)]
	set alpha [expr sin($H)]
	set beta  [expr cos($H)]
	set r [expr round($I+$S*($alpha/$s_6-$beta/$s_2))]
	if {$r<0} {set r 0}
	if {$r>15} {set r 15}
	set g [expr round($I+$S*($alpha/$s_6+$beta/$s_2))]
	if {$g<0} {set g 0}
	if {$g>15} {set g 15}
	set b [expr round($I+$S*(-2*$alpha/$s_6))]
	if {$b<0} {set b 0}
	if {$b>15} {set b 15}
	set R [lindex $hex_list $r]
	set G [lindex $hex_list $g]
	set B [lindex $hex_list $b]
	lappend color_list \#$R$G$B
	} }

#set color_list [lsort -decreasing $color_list ]
set n_colors [llength $color_list]

puts $n_colors

canvas .canvas

for {set i 0} {$i<$n_colors} {incr i} {
	set x [expr ($i % 10)*25+2]
	set y [expr ($i/10)*25+2]
	.canvas create oval $x $y [expr $x+20] [expr $y+20] \
	 	-fill [lindex $color_list $i]
	}

pack .canvas -fill both -expand yes	
	
